function out = erode_param(egl, esa, hp)

%% Unpack input 
 
eglg = (egl./10) .* 2.65; % convert input to [g/cm^2 per yr]
esag = (esa./10) .* 2.65; % convert input to [g/cm^2 per yr]

%% create model inputs

% get vector of erosion rates in g/cm^2 per year
ep.e_rate = zeros(1, length(hp.t_eb));
ep.e_rate(hp.p_mask == 1) = esag;
ep.e_rate(hp.p_mask == 0) = eglg; % this won't work if want erosion rates to vary each timestep. will need to revisit.

out = ep;
end
